---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-Spark Connect Server Session Detail（Connectセッション詳細）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **権限による表示制御**：ソースコード上に明示的な権限チェックが見当たらないため推定

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerSessionPage.scala`（132行）
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerAppStatusStore.scala`（132行）
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerTab.scala`（60行）
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerPage.scala`（527行）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/connect/session/?id={sessionId}` | E-01 (31行目: `WebUIPage("session")`), E-03 (30行目: `SparkUITab(sparkUI, "connect")`) | ○ |
| C-02 | idパラメータは必須でnull/空文字チェックされる | E-01 (39-40行目: `require(sessionId != null && sessionId.nonEmpty)`) | ○ |
| C-03 | セッション情報はstore.getSessionで取得 | E-01 (44行目), E-02 (42-48行目) | ○ |
| C-04 | セッション未発見時は「No information to display」メッセージ表示 | E-01 (61行目: `.getOrElse(<div>No information to display...)`) | ○ |
| C-05 | 基本情報にSession ID, Started at, Time since startを表示 | E-01 (67-80行目: `generateBasicStats`) | ○ |
| C-06 | セッション概要にUser, Session created at, Total runを表示 | E-01 (46-58行目: `sessionStat.userId`, `sessionStat.startTimestamp`, `sessionStat.totalExecution`) | ○ |
| C-07 | SQL統計テーブルはセッションIDでフィルタリング | E-01 (84-85行目: `store.getExecutionList.filter(_.sessionId == sessionID)`) | ○ |
| C-08 | SqlStatsPagedTableでshowSessionLink=false | E-01 (103行目: `showSessionLink = false`) | ○ |
| C-09 | テーブルのカラムにUser, Job ID, SQL Query ID等14カラムがある | E-04 (231-246行目: showSessionLink=falseの場合のヘッダ定義) | ○ |
| C-10 | ソートはURLパラメータで管理される | E-04 (180-181行目: `getTableParameters`, 195-201行目: `pageLink`) | ○ |
| C-11 | ページネーションはsqlsessionstatタグで管理 | E-01 (89行目: `val sqlTableTag = "sqlsessionstat"`) | ○ |
| C-12 | store.synchronizedでデータ一貫性保証 | E-01 (42行目: `store.synchronized`) | ○ |
| C-13 | ExecutionStateはSTARTED, COMPILED, READY, CANCELED, FAILED, FINISHED, CLOSEDの7値 | E-02 (128-131行目: `object ExecutionState`) | ○ |
| C-14 | isExecutionActiveがtrueの場合Stateは"RUNNING"と表示 | E-04 (321行目: `if (info.isExecutionActive) "RUNNING" else info.state`) | ○ |
| C-15 | ジョブリンクは `/jobs/job/?id={jobId}` | E-04 (336-337行目: `jobURL`) | ○ |
| C-16 | SQLリンクは `/SQL/execution/?id={sqlExecId}` | E-04 (339-340行目: `sqlURL`) | ○ |
| C-17 | 画面遷移元はConnect Server Overview | E-07 (ConnectOverview --> ConnectSessionDetail) | ○ |
| C-18 | 権限による表示制御は特になし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: SparkConnectServerSessionPageにはアクセス制御の明示的なコードがないことから「特になし」と推定したが、Spark UIフレームワーク側（SecurityManager, AclsFilter等）での制御の有無は未確認
  - 候補：SecurityManager / spark.acls.enable / spark.ui.filters

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコード直読により大部分の主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] セッションID未指定時のエラーメッセージが正しいか確認
- [ ] Request StatisticsテーブルのカラムがshowSessionLink=falseの場合に正しいか確認
- [ ] Spark UIのアクセス制御フレームワークの記述が必要か判断
